/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.agriculture;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.IFruitTree;
import net.dries007.tfc.api.util.IGrowingPlant;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeLeaves;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeSapling;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeTrunk;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockFruitTreeBranch
extends Block
implements IGrowingPlant {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    public static final PropertyInteger NORTH = PropertyInteger.func_177719_a((String)"north", (int)0, (int)2);
    public static final PropertyInteger EAST = PropertyInteger.func_177719_a((String)"east", (int)0, (int)2);
    public static final PropertyInteger SOUTH = PropertyInteger.func_177719_a((String)"south", (int)0, (int)2);
    public static final PropertyInteger WEST = PropertyInteger.func_177719_a((String)"west", (int)0, (int)2);
    public static final PropertyInteger UP = PropertyInteger.func_177719_a((String)"up", (int)0, (int)2);
    private static final AxisAlignedBB TRUNK_N_AABB = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 1.0);
    private static final AxisAlignedBB TRUNK_E_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 0.625, 0.625, 0.625);
    private static final AxisAlignedBB TRUNK_S_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.625);
    private static final AxisAlignedBB TRUNK_W_AABB = new AxisAlignedBB(0.375, 0.375, 0.375, 1.0, 0.625, 0.625);
    private static final AxisAlignedBB TRUNK_U_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    private static final AxisAlignedBB CONNECTION_N_AABB = new AxisAlignedBB(0.3125, 0.375, 0.0, 0.0, 0.625, 0.3125);
    private static final AxisAlignedBB CONNECTION_S_AABB = new AxisAlignedBB(0.3125, 0.375, 0.6875, 0.0, 0.625, 1.0);
    private static final AxisAlignedBB CONNECTION_W_AABB = new AxisAlignedBB(0.0, 0.375, 0.3125, 0.3125, 0.625, 0.6875);
    private static final AxisAlignedBB CONNECTION_E_AABB = new AxisAlignedBB(0.6875, 0.375, 0.3125, 1.0, 0.625, 0.6875);
    private static final Map<IFruitTree, BlockFruitTreeBranch> MAP = new HashMap<IFruitTree, BlockFruitTreeBranch>();
    private final IFruitTree tree;

    public static BlockFruitTreeBranch get(IFruitTree tree) {
        return MAP.get(tree);
    }

    public BlockFruitTreeBranch(IFruitTree tree) {
        super(Material.field_151575_d, Material.field_151575_d.func_151565_r());
        if (MAP.put(tree, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.tree = tree;
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)NORTH, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)EAST, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)SOUTH, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)WEST, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)UP, (Comparable)Integer.valueOf(0)));
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int connectedValue;
        EnumFacing face = this.getFacing(worldIn, pos);
        if (face == null || face == EnumFacing.UP || face == EnumFacing.DOWN) {
            state = state.func_177226_a(FACING, (Comparable)EnumFacing.UP);
            connectedValue = 1;
        } else {
            state = state.func_177226_a(FACING, (Comparable)face);
            connectedValue = 2;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!(worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof BlockFruitTreeLeaves)) continue;
            if (facing == EnumFacing.NORTH) {
                state = state.func_177226_a((IProperty)NORTH, (Comparable)Integer.valueOf(connectedValue));
                continue;
            }
            if (facing == EnumFacing.SOUTH) {
                state = state.func_177226_a((IProperty)SOUTH, (Comparable)Integer.valueOf(connectedValue));
                continue;
            }
            if (facing == EnumFacing.EAST) {
                state = state.func_177226_a((IProperty)EAST, (Comparable)Integer.valueOf(connectedValue));
                continue;
            }
            if (facing == EnumFacing.WEST) {
                state = state.func_177226_a((IProperty)WEST, (Comparable)Integer.valueOf(connectedValue));
                continue;
            }
            if (facing != EnumFacing.UP) continue;
            state = state.func_177226_a((IProperty)UP, (Comparable)Integer.valueOf(connectedValue));
        }
        return state;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB finalAABB;
        state = this.func_176221_a(state, source, pos);
        switch ((EnumFacing)state.func_177229_b(FACING)) {
            case NORTH: {
                finalAABB = TRUNK_N_AABB;
                break;
            }
            case EAST: {
                finalAABB = TRUNK_E_AABB;
                break;
            }
            case SOUTH: {
                finalAABB = TRUNK_S_AABB;
                break;
            }
            case WEST: {
                finalAABB = TRUNK_W_AABB;
                break;
            }
            default: {
                finalAABB = TRUNK_U_AABB;
            }
        }
        if ((Integer)state.func_177229_b((IProperty)NORTH) > 0) {
            finalAABB = finalAABB.func_111270_a(CONNECTION_N_AABB);
        }
        if ((Integer)state.func_177229_b((IProperty)EAST) > 0) {
            finalAABB = finalAABB.func_111270_a(CONNECTION_E_AABB);
        }
        if ((Integer)state.func_177229_b((IProperty)SOUTH) > 0) {
            finalAABB = finalAABB.func_111270_a(CONNECTION_S_AABB);
        }
        if ((Integer)state.func_177229_b((IProperty)WEST) > 0) {
            finalAABB = finalAABB.func_111270_a(CONNECTION_W_AABB);
        }
        return finalAABB;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (this.getFacing((IBlockAccess)worldIn, pos) == null) {
            worldIn.func_175698_g(pos);
        }
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if ((stack.func_77973_b().getToolClasses(stack).contains("axe") || stack.func_77973_b().getToolClasses(stack).contains("saw")) && !worldIn.field_72995_K && RANDOM.nextBoolean()) {
            ItemStack dropStack = new ItemStack((Block)BlockFruitTreeSapling.get(this.tree));
            InventoryHelper.func_180173_a((World)worldIn, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)dropStack);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, NORTH, EAST, SOUTH, WEST, UP});
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)BlockFruitTreeSapling.get(this.tree));
    }

    @Nonnull
    public IFruitTree getTree() {
        return this.tree;
    }

    private EnumFacing getFacing(IBlockAccess worldIn, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != BlockFruitTreeTrunk.get(this.tree)) continue;
            return facing.func_176734_d();
        }
        return null;
    }

    @Override
    public IGrowingPlant.GrowthStatus getGrowingStatus(IBlockState state, World world, BlockPos pos) {
        float rainfall;
        float temp = ClimateTFC.getActualTemp(world, pos);
        boolean canGrow = this.tree.isValidForGrowth(temp, rainfall = ChunkDataTFC.getRainfall(world, pos));
        if (canGrow) {
            return IGrowingPlant.GrowthStatus.GROWING;
        }
        return IGrowingPlant.GrowthStatus.NOT_GROWING;
    }
}

